// Frost shimmer: adds cold highlights + subtle snow texture modulation.
const float px = 1.0 / 64.0;

uniform float u_Time;
uniform sampler2D u_Tex0;
uniform sampler2D u_Tex1; // optional noise/snow texture (we ship images/snow.png)
varying vec2 v_TexCoord;

float a(vec2 uv) { return texture2D(u_Tex0, uv).a; }

void main() {
  vec4 col = texture2D(u_Tex0, v_TexCoord);
  if (col.a < 0.01) { gl_FragColor = col; return; }

  // Edge highlight
  float edge = a(v_TexCoord + vec2(px,0.0)) +
               a(v_TexCoord + vec2(-px,0.0)) +
               a(v_TexCoord + vec2(0.0,px)) +
               a(v_TexCoord + vec2(0.0,-px));
  float isEdge = step(0.02, edge) * (1.0 - step(0.10, col.a));

  // Snow/noise texture scroll
  vec2 uv1 = v_TexCoord * 1.8 + vec2(u_Time * 0.03, -u_Time * 0.02);
  float n = texture2D(u_Tex1, uv1).r;

  float shimmer = 0.35 * n + 0.25 * (sin(u_Time * 3.0 + v_TexCoord.x * 14.0) + 1.0) * 0.5;
  vec3 frostColor = vec3(0.60, 0.85, 1.00);

  vec3 rgb = col.rgb;
  rgb = mix(rgb, frostColor, shimmer * 0.25);
  rgb += frostColor * isEdge * 0.65;

  gl_FragColor = vec4(rgb, col.a);
}
